# IntentRank WordPress Plugin

A WordPress plugin that integrates with IntentRank to automatically post articles to your WordPress blog. The plugin provides a seamless integration that allows IntentRank to send articles directly to your WordPress site via REST API endpoints.

## Features

- **Integration Key Authentication**: Secure API authentication using integration keys with multiple authentication methods
- **Flexible Post Modes**: Choose whether posts are published immediately or saved as drafts for review
- **Dual REST API Endpoints**: 
  - Modern `/articles` endpoint for bulk article processing (recommended)
  - Legacy `/post` endpoint for backward compatibility
- **Test Endpoint**: Verify your integration configuration with the `/test` endpoint
- **Full Post Support**: Supports title, content (HTML/Markdown), excerpt, categories, tags, featured images, and custom slugs
- **SEO Integration**: Automatic focus keyword support for popular SEO plugins (Yoast SEO, Rank Math, SEOPress, The SEO Framework)
- **Automatic Category/Tag Creation**: Automatically creates categories and tags if they don't exist
- **Smart Image Handling**: 
  - Downloads featured images from external URLs (including S3)
  - Automatically inserts images into post content
  - Saves images to WordPress media library
- **Admin Interface**: 
  - Articles management page with unpublished article count
  - Manual publish functionality for draft articles
  - Bulk publish capability
  - Settings page with API endpoint information
- **Content Processing**: Automatically cleans HTML content (removes code block markers)
- **Custom Post Type**: Uses a dedicated post type to track IntentRank articles separately from regular posts

## Installation

1. Upload the `intentrank-wordpress-plugin` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Navigate to Settings > IntentRank to configure your integration

## Configuration

### 1. Get Your Integration Key

1. Log in to your IntentRank account
2. Navigate to WordPress integration settings
3. Generate your Integration Key
4. Copy the key

### 2. Configure Plugin Settings

1. Go to **IntentRank > Settings** in your WordPress admin panel (or navigate to Settings > IntentRank)
2. Paste your Integration Key in the "Integration Key" field
3. Select your Post Mode:
   - **Save as Draft**: Posts will be saved as drafts in the IntentRank Articles section for review and manual publishing
   - **Post Directly**: Posts will be published immediately to your WordPress blog
4. Click "Save Settings"

### 3. Managing Articles

After configuration, you can manage incoming articles:

- **View Articles**: Go to **IntentRank > Articles** to see all received articles
- **Unpublished Count**: The menu shows a badge with the count of unpublished articles
- **Publish Articles**: Click "Publish" on individual articles or use "Bulk Publish" for multiple articles
- **Edit Articles**: Click on any article to edit it before publishing

### 4. API Endpoints Display

The settings page displays your API endpoints:
- **Articles Endpoint**: `/wp-json/intentrank/v1/articles` (recommended for new integrations)
- **Legacy Post Endpoint**: `/wp-json/intentrank/v1/post` (for backward compatibility)

Copy these URLs to configure in your IntentRank account.

## API Usage

The plugin provides three REST API endpoints:

### 1. Articles Endpoint (Recommended)

```
POST /wp-json/intentrank/v1/articles
```

This is the main endpoint for receiving articles from IntentRank. It supports bulk article processing with the new payload format.

**Request Body:**
```json
{
  "data": {
    "articles": [
      {
        "id": "article-123",
        "title": "Your Article Title",
        "content_html": "<p>Your article content in HTML format.</p>",
        "content_markdown": "Your article content in Markdown format.",
        "meta_description": "SEO meta description",
        "slug": "your-article-slug",
        "tags": ["tag1", "tag2"],
        "image_url": "https://example.com/image.jpg",
        "keyword": "focus keyword for SEO"
      }
    ]
  }
}
```

**Response:**
```json
{
  "success": true,
  "results": [
    {
      "success": true,
      "article_id": "article-123",
      "post_id": 456,
      "post_status": "draft"
    }
  ]
}
```

### 2. Legacy Post Endpoint

```
POST /wp-json/intentrank/v1/post
```

Legacy endpoint for backward compatibility. Supports single post creation.

### Authentication

You can authenticate using one of the following methods:

1. **Authorization Header** (Recommended):
   ```
   Authorization: Bearer YOUR_INTEGRATION_KEY
   ```

2. **X-API-Key Header**:
   ```
   X-API-Key: YOUR_INTEGRATION_KEY
   ```

3. **Query Parameter**:
   ```
   ?api_key=YOUR_INTEGRATION_KEY
   ```

**Request Body:**
```json
{
  "title": "Your Post Title",
  "content": "<p>Your post content in HTML format.</p>",
  "excerpt": "Optional post excerpt",
  "categories": ["Category Name", "Another Category"],
  "tags": ["tag1", "tag2", "tag3"],
  "featured_image": "https://example.com/image.jpg"
}
```

**Parameters:**

| Parameter | Type | Required | Description |
|-----------|------|----------|-------------|
| `title` | string | Yes | The post title |
| `content` | string | Yes | The post content (HTML supported, code block markers are automatically removed) |
| `excerpt` | string | No | Post excerpt/summary |
| `categories` | array | No | Array of category names or IDs |
| `tags` | array | No | Array of tag names or IDs |
| `featured_image` | string | No | URL to the featured image (will be downloaded and saved to media library) |

### 3. Test Endpoint

```
GET /wp-json/intentrank/v1/test
```

Use this endpoint to verify your integration configuration and API key.

**Response:**
```json
{
  "success": true,
  "plugin_version": "1.0.0",
  "post_mode": "draft",
  "key_configured": true,
  "message": "Integration key is valid and plugin is ready to receive articles."
}
```

### Response

**Success Response (200 OK):**
```json
{
  "success": true,
  "post_id": 123,
  "post_status": "draft",
  "message": "Post created successfully as draft.",
  "edit_link": "https://yoursite.com/wp-admin/post.php?action=edit&post=123"
}
```

**Error Response (401 Unauthorized):**
```json
{
  "code": "invalid_api_key",
  "message": "Invalid integration key.",
  "data": {
    "status": 401
  }
}
```

## Example Requests

### Articles Endpoint (Recommended)

```bash
curl -X POST https://yoursite.com/wp-json/intentrank/v1/articles \
  -H "Authorization: Bearer YOUR_INTEGRATION_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "data": {
      "articles": [
        {
          "id": "article-123",
          "title": "My New Blog Post",
          "content_html": "<p>This is the content of my blog post.</p>",
          "content_markdown": "This is the content of my blog post.",
          "meta_description": "A brief summary of the post",
          "slug": "my-new-blog-post",
          "tags": ["plugin", "api"],
          "image_url": "https://example.com/image.jpg",
          "keyword": "wordpress plugin"
        }
      ]
    }
  }'
```

### Legacy Post Endpoint

```bash
curl -X POST https://yoursite.com/wp-json/intentrank/v1/post \
  -H "Authorization: Bearer YOUR_INTEGRATION_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "title": "My New Blog Post",
    "content": "<p>This is the content of my blog post.</p>",
    "excerpt": "A brief summary of the post",
    "categories": ["Technology", "WordPress"],
    "tags": ["plugin", "api"],
    "featured_image": "https://example.com/image.jpg"
  }'
```

### Test Endpoint

```bash
curl -X GET https://yoursite.com/wp-json/intentrank/v1/test \
  -H "Authorization: Bearer YOUR_INTEGRATION_KEY"
```

## Example PHP Requests

### Articles Endpoint (Recommended)

```php
$response = wp_remote_post('https://yoursite.com/wp-json/intentrank/v1/articles', array(
    'headers' => array(
        'Authorization' => 'Bearer YOUR_INTEGRATION_KEY',
        'Content-Type' => 'application/json',
    ),
    'body' => json_encode(array(
        'data' => array(
            'articles' => array(
                array(
                    'id' => 'article-123',
                    'title' => 'My New Blog Post',
                    'content_html' => '<p>This is the content of my blog post.</p>',
                    'content_markdown' => 'This is the content of my blog post.',
                    'meta_description' => 'A brief summary of the post',
                    'slug' => 'my-new-blog-post',
                    'tags' => array('plugin', 'api'),
                    'image_url' => 'https://example.com/image.jpg',
                    'keyword' => 'wordpress plugin'
                )
            )
        )
    )),
));
```

### Legacy Post Endpoint

```php
$response = wp_remote_post('https://yoursite.com/wp-json/intentrank/v1/post', array(
    'headers' => array(
        'Authorization' => 'Bearer YOUR_INTEGRATION_KEY',
        'Content-Type' => 'application/json',
    ),
    'body' => json_encode(array(
        'title' => 'My New Blog Post',
        'content' => '<p>This is the content of my blog post.</p>',
        'excerpt' => 'A brief summary of the post',
        'categories' => array('Technology', 'WordPress'),
        'tags' => array('plugin', 'api'),
        'featured_image' => 'https://example.com/image.jpg'
    )),
));
```

## Advanced Features

### SEO Keyword Support

The plugin automatically saves focus keywords for popular SEO plugins:
- **Yoast SEO**: Saves to `_yoast_wpseo_focuskw`
- **Rank Math**: Saves to `rank_math_focus_keyword`
- **SEOPress**: Saves to `_seopress_analysis_target_kw`
- **The SEO Framework**: Saves to `_tsf_focus`

Keywords are sent in the `keyword` field of the articles endpoint payload.

### Image Handling

- **Automatic Download**: Featured images are automatically downloaded from external URLs (including S3)
- **Media Library**: Images are saved to the WordPress media library
- **Content Insertion**: Images are automatically inserted at the beginning of post content
- **Thumbnail Generation**: WordPress automatically generates thumbnails and attachment metadata

### Content Processing

- **HTML Cleaning**: Automatically removes code block markers (markdown code fences) from content
- **Sanitization**: All content is sanitized using WordPress's built-in functions
- **HTML Filtering**: HTML content is filtered using `wp_kses_post()` to prevent XSS attacks

## Security

- All API requests are validated using the Integration Key
- Multiple authentication methods supported (Authorization header, X-API-Key header, or query parameter)
- Post content is sanitized using WordPress's built-in sanitization functions
- HTML content is filtered using `wp_kses_post()` to prevent XSS attacks
- The plugin follows WordPress coding standards and security best practices
- Only users with `manage_options` capability can access admin pages

## Requirements

- WordPress 5.0 or higher
- PHP 7.2 or higher

## Support

For support, please contact IntentRank support or visit the plugin documentation.

## Changelog

### 1.0.0
- Initial release
- Integration key authentication with multiple methods
- Draft and publish post modes
- Full post support (title, content, excerpt, categories, tags, featured images, slugs)
- Dual REST API endpoints (articles and legacy post)
- Test endpoint for integration verification
- SEO keyword support for Yoast SEO, Rank Math, SEOPress, and The SEO Framework
- Automatic image download and media library integration
- Content cleaning (removes code block markers)
- Admin interface with articles management
- Manual and bulk publish functionality
- Custom post type for IntentRank articles tracking

## License

This plugin is licensed under the GNU General Public License v2 or later.

```
IntentRank WordPress Plugin
Copyright (C) 2024 IntentRank

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
```



